/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import javax.websocket.Session;
import org.glassfish.tyrus.client.RedirectException;
import org.glassfish.tyrus.client.RetryAfterException;
import org.glassfish.tyrus.client.auth.AuthConfig;
import org.glassfish.tyrus.client.auth.AuthenticationException;
import org.glassfish.tyrus.client.auth.Authenticator;
import org.glassfish.tyrus.client.auth.Credentials;
import org.glassfish.tyrus.core.DebugContext;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.MaskingKeyGenerator;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

public class TyrusClientEngine
implements ClientEngine {
    public static final int DEFAULT_INCOMING_BUFFER_SIZE = 0x40000B;
    private static final Logger LOGGER = Logger.getLogger(TyrusClientEngine.class.getName());
    private static final Version DEFAULT_VERSION = Version.DRAFT17;
    private static final int BUFFER_STEP_SIZE = 256;
    private static final int DEFAULT_REDIRECT_THRESHOLD = 5;
    private final ProtocolHandler protocolHandler;
    private final TyrusEndpointWrapper endpointWrapper;
    private final ClientHandshakeListener listener;
    private final Map<String, Object> properties;
    private final URI connectToServerUriParam;
    private final Boolean redirectEnabled;
    private final int redirectThreshold;
    private final DebugContext debugContext;
    private final boolean logUpgradeMessages;
    private volatile Handshake clientHandShake = null;
    private volatile ClientEngine.TimeoutHandler timeoutHandler = null;
    private volatile TyrusClientEngineState clientEngineState = TyrusClientEngineState.INIT;
    private volatile URI redirectLocation = null;
    private final Set<URI> redirectUriHistory;
    private static final ClientEngine.ClientUpgradeInfo UPGRADE_INFO_FAILED = new ClientEngine.ClientUpgradeInfo(){

        @Override
        public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
            return ClientEngine.ClientUpgradeStatus.UPGRADE_REQUEST_FAILED;
        }

        @Override
        public Connection createConnection() {
            return null;
        }
    };
    private static final ClientEngine.ClientUpgradeInfo UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED = new ClientEngine.ClientUpgradeInfo(){

        @Override
        public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
            return ClientEngine.ClientUpgradeStatus.ANOTHER_UPGRADE_REQUEST_REQUIRED;
        }

        @Override
        public Connection createConnection() {
            return null;
        }
    };

    TyrusClientEngine(TyrusEndpointWrapper endpointWrapper, ClientHandshakeListener listener, Map<String, Object> properties, URI connectToServerUriParam, DebugContext debugContext) {
        this.endpointWrapper = endpointWrapper;
        this.listener = listener;
        this.properties = properties;
        this.connectToServerUriParam = connectToServerUriParam;
        MaskingKeyGenerator maskingKeyGenerator = Utils.getProperty(properties, "org.glassfish.tyrus.client.maskingKeyGenerator", MaskingKeyGenerator.class, null);
        this.protocolHandler = DEFAULT_VERSION.createHandler(true, maskingKeyGenerator);
        this.redirectUriHistory = Collections.synchronizedSet(new HashSet(5));
        this.redirectEnabled = Utils.getProperty(properties, "org.glassfish.tyrus.client.http.redirect", Boolean.class, false);
        Integer redirectThreshold = Utils.getProperty(properties, "org.glassfish.tyrus.client.http.redirect.threshold", Integer.class, 5);
        if (redirectThreshold == null) {
            redirectThreshold = 5;
        }
        this.redirectThreshold = redirectThreshold;
        this.debugContext = debugContext;
        this.logUpgradeMessages = Utils.getProperty(properties, "org.glassfish.tyrus.client.http.logUpgrade", Boolean.class, false);
        debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, "Redirect enabled: ", this.redirectEnabled);
        if (this.redirectEnabled.booleanValue()) {
            debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, "Redirect threshold: ", redirectThreshold);
        }
    }

    @Override
    public UpgradeRequest createUpgradeRequest(ClientEngine.TimeoutHandler timeoutHandler) {
        switch (this.clientEngineState) {
            case INIT: {
                ClientEndpointConfig config = (ClientEndpointConfig)this.endpointWrapper.getEndpointConfig();
                this.timeoutHandler = timeoutHandler;
                this.clientHandShake = Handshake.createClientHandshake(RequestContext.Builder.create().requestURI(this.connectToServerUriParam).secure("wss".equals(this.connectToServerUriParam.getScheme())).build());
                this.clientHandShake.setExtensions(config.getExtensions());
                this.clientHandShake.setSubProtocols(config.getPreferredSubprotocols());
                this.clientHandShake.prepareRequest();
                RequestContext upgradeRequest = this.clientHandShake.getRequest();
                config.getConfigurator().beforeRequest(upgradeRequest.getHeaders());
                this.clientEngineState = TyrusClientEngineState.UPGRADE_REQUEST_CREATED;
                this.logUpgradeRequest(upgradeRequest);
                return upgradeRequest;
            }
            case REDIRECT_REQUIRED: {
                this.timeoutHandler = timeoutHandler;
                URI requestUri = this.redirectLocation;
                RequestContext requestContext = RequestContext.Builder.create(this.clientHandShake.getRequest()).requestURI(requestUri).secure("wss".equalsIgnoreCase(requestUri.getScheme())).build();
                Handshake.updateHostAndOrigin(requestContext);
                this.clientEngineState = TyrusClientEngineState.UPGRADE_REQUEST_CREATED;
                this.logUpgradeRequest(requestContext);
                return requestContext;
            }
            case AUTH_REQUIRED: {
                RequestContext upgradeRequest = this.clientHandShake.getRequest();
                if (this.clientEngineState.getAuthenticator() != null) {
                    String authorizationHeader;
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        this.debugContext.appendLogMessage(LOGGER, Level.CONFIG, DebugContext.Type.MESSAGE_OUT, "Using authenticator: ", this.clientEngineState.getAuthenticator().getClass().getName());
                    }
                    try {
                        Credentials credentials = (Credentials)this.properties.get("org.glassfish.tyrus.client.http.auth.Credentials");
                        this.debugContext.appendLogMessage(LOGGER, Level.CONFIG, DebugContext.Type.MESSAGE_OUT, "Using credentials: ", credentials);
                        authorizationHeader = this.clientEngineState.getAuthenticator().generateAuthorizationHeader(upgradeRequest.getRequestURI(), this.clientEngineState.getWwwAuthenticateHeader(), credentials);
                    }
                    catch (AuthenticationException e) {
                        this.listener.onError(e);
                        return null;
                    }
                    upgradeRequest.getHeaders().put("Authorization", Collections.singletonList(authorizationHeader));
                }
                this.clientEngineState = TyrusClientEngineState.AUTH_UPGRADE_REQUEST_CREATED;
                this.logUpgradeRequest(upgradeRequest);
                return upgradeRequest;
            }
        }
        this.redirectUriHistory.clear();
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ClientEngine.ClientUpgradeInfo processResponse(UpgradeResponse upgradeResponse, Writer writer, Connection.CloseListener closeListener) {
        if (TyrusClientEngine.LOGGER.isLoggable(Level.FINE)) {
            this.debugContext.appendLogMessage(TyrusClientEngine.LOGGER, Level.FINE, DebugContext.Type.MESSAGE_IN, new Object[]{"Received handshake response: \n" + Utils.stringifyUpgradeResponse(upgradeResponse)});
        } else if (this.logUpgradeMessages) {
            this.debugContext.appendStandardOutputMessage(DebugContext.Type.MESSAGE_IN, "Received handshake response: \n" + Utils.stringifyUpgradeResponse(upgradeResponse));
        }
        switch (5.$SwitchMap$org$glassfish$tyrus$client$TyrusClientEngine$TyrusClientEngineState[this.clientEngineState.ordinal()]) {
            case 4: 
            case 5: {
                if (upgradeResponse == null) {
                    throw new IllegalArgumentException(LocalizationMessages.ARGUMENT_NOT_NULL("upgradeResponse"));
                }
                switch (upgradeResponse.getStatus()) {
                    case 101: {
                        this.clientEngineState = TyrusClientEngineState.SUCCESS;
                        try {
                            var4_4 = this.processUpgradeResponse(upgradeResponse, writer, closeListener);
                            return var4_4;
                        }
                        catch (HandshakeException e) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(e);
                            var5_7 = TyrusClientEngine.UPGRADE_INFO_FAILED;
                            return var5_7;
                        }
                        finally {
                            this.redirectUriHistory.clear();
                        }
                    }
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: 
                    case 308: {
                        if (!this.redirectEnabled.booleanValue()) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NOT_ENABLED(upgradeResponse.getStatus())));
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        locationString = null;
                        locationHeader = upgradeResponse.getHeaders().get("Location");
                        if (locationHeader != null) {
                            locationString = Utils.getHeaderFromList(locationHeader);
                        }
                        if (locationString == null || locationString.equals("")) {
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NEW_LOCATION_MISSING()));
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        try {
                            location = new URI(locationString);
                            scheme = location.getScheme();
                            if ("http".equalsIgnoreCase(scheme)) {
                                scheme = "ws";
                            }
                            if ("https".equalsIgnoreCase(scheme)) {
                                scheme = "wss";
                            }
                            port = Utils.getWsPort(location, scheme);
                            if (!(location = new URI(scheme, location.getUserInfo(), location.getHost(), port, location.getPath(), location.getQuery(), location.getFragment())).isAbsolute()) {
                                baseUri = this.redirectLocation == null ? this.connectToServerUriParam : this.redirectLocation;
                                location = baseUri.resolve(location.normalize());
                                if (TyrusClientEngine.LOGGER.isLoggable(Level.FINEST)) {
                                    TyrusClientEngine.LOGGER.finest("HTTP Redirect - Base URI for resolving target location: " + baseUri);
                                    TyrusClientEngine.LOGGER.finest("HTTP Redirect - Location URI header: " + locationString);
                                    TyrusClientEngine.LOGGER.finest("HTTP Redirect - Normalized and resolved Location URI header against base URI: " + location);
                                }
                            }
                        }
                        catch (URISyntaxException e) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NEW_LOCATION_ERROR(locationString)));
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        v0 = alreadyRequested = this.redirectUriHistory.add(location) == false;
                        if (alreadyRequested) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_INFINITE_LOOP()));
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        if (this.redirectUriHistory.size() > this.redirectThreshold) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_MAX_REDIRECTION(this.redirectThreshold)));
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        this.clientEngineState = TyrusClientEngineState.REDIRECT_REQUIRED;
                        this.redirectLocation = location;
                        return TyrusClientEngine.UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED;
                    }
                    case 401: {
                        if (this.clientEngineState == TyrusClientEngineState.AUTH_UPGRADE_REQUEST_CREATED) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED()));
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        authConfig = Utils.getProperty(this.properties, "org.glassfish.tyrus.client.http.auth.AuthConfig", AuthConfig.class, AuthConfig.Builder.create().build());
                        this.debugContext.appendLogMessage(TyrusClientEngine.LOGGER, Level.FINE, DebugContext.Type.MESSAGE_OUT, new Object[]{"Using authentication config: ", authConfig});
                        if (authConfig == null) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED()));
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        wwwAuthenticateHeader = null;
                        authHeader = upgradeResponse.getHeaders().get("WWW-Authenticate");
                        if (authHeader != null) {
                            wwwAuthenticateHeader = Utils.getHeaderFromList(authHeader);
                        }
                        if (wwwAuthenticateHeader == null || wwwAuthenticateHeader.equals("")) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED()));
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        tokens = wwwAuthenticateHeader.trim().split("\\s+", 2);
                        scheme = tokens[0];
                        this.debugContext.appendLogMessage(TyrusClientEngine.LOGGER, Level.FINE, DebugContext.Type.MESSAGE_OUT, new Object[]{"Using authentication scheme: ", scheme});
                        authenticator = authConfig.getAuthenticators().get(scheme);
                        if (authenticator == null) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED()));
                            return TyrusClientEngine.UPGRADE_INFO_FAILED;
                        }
                        this.clientEngineState = TyrusClientEngineState.AUTH_REQUIRED;
                        this.clientEngineState.setAuthenticator(authenticator);
                        this.clientEngineState.setWwwAuthenticateHeader(wwwAuthenticateHeader);
                        return TyrusClientEngine.UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED;
                    }
                    case 503: {
                        retryAfterString = null;
                        retryAfterHeader = upgradeResponse.getHeaders().get("Retry-After");
                        if (retryAfterHeader != null) {
                            retryAfterString = Utils.getHeaderFromList(retryAfterHeader);
                        }
                        if (retryAfterString == null) ** GOTO lbl117
                        try {
                            date = Utils.parseHttpDate(retryAfterString);
                            delay = (date.getTime() - System.currentTimeMillis()) / 1000L;
                        }
                        catch (ParseException e) {
                            try {
                                delay = Long.parseLong(retryAfterString);
                                ** GOTO lbl118
                            }
                            catch (NumberFormatException iae) {
                                delay = null;
                            }
                        }
                        ** GOTO lbl118
lbl117:
                        // 1 sources

                        delay = null;
lbl118:
                        // 4 sources

                        this.listener.onError(new RetryAfterException(LocalizationMessages.HANDSHAKE_HTTP_RETRY_AFTER_MESSAGE(), delay));
                        return TyrusClientEngine.UPGRADE_INFO_FAILED;
                    }
                }
                this.clientEngineState = TyrusClientEngineState.FAILED;
                e = new HandshakeException(upgradeResponse.getStatus(), LocalizationMessages.INVALID_RESPONSE_CODE(101, upgradeResponse.getStatus()));
                this.listener.onError(e);
                this.redirectUriHistory.clear();
                return TyrusClientEngine.UPGRADE_INFO_FAILED;
            }
        }
        this.redirectUriHistory.clear();
        throw new IllegalStateException();
    }

    @Override
    public void processError(Throwable t) {
        if (this.clientEngineState == TyrusClientEngineState.SUCCESS) {
            throw new IllegalStateException();
        }
        if (this.clientEngineState != TyrusClientEngineState.FAILED) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError(t);
        }
    }

    private void logUpgradeRequest(UpgradeRequest upgradeRequest) {
        if (LOGGER.isLoggable(Level.FINE)) {
            this.debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.MESSAGE_OUT, "Sending handshake request:\n" + Utils.stringifyUpgradeRequest(upgradeRequest));
        } else if (this.logUpgradeMessages) {
            this.debugContext.appendStandardOutputMessage(DebugContext.Type.MESSAGE_OUT, "Sending handshake request:\n" + Utils.stringifyUpgradeRequest(upgradeRequest));
        }
    }

    private ClientEngine.ClientUpgradeInfo processUpgradeResponse(UpgradeResponse upgradeResponse, final Writer writer, final Connection.CloseListener closeListener) throws HandshakeException {
        this.clientHandShake.validateServerResponse(upgradeResponse);
        final TyrusWebSocket socket = new TyrusWebSocket(this.protocolHandler, this.endpointWrapper);
        List<Extension> handshakeResponseExtensions = TyrusExtension.fromHeaders(upgradeResponse.getHeaders().get("Sec-WebSocket-Extensions"));
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        final ExtendedExtension.ExtensionContext extensionContext = new ExtendedExtension.ExtensionContext(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            @Override
            public Map<String, Object> getProperties() {
                return this.properties;
            }
        };
        for (Extension responseExtension : handshakeResponseExtensions) {
            for (Extension installedExtension : ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getExtensions()) {
                String responseExtensionName = responseExtension.getName();
                if (responseExtensionName == null || !responseExtensionName.equals(installedExtension.getName())) continue;
                boolean alreadyAdded = false;
                for (Extension extension2 : extensions) {
                    if (!extension2.getName().equals(responseExtensionName)) continue;
                    alreadyAdded = true;
                }
                if (alreadyAdded) continue;
                if (installedExtension instanceof ExtendedExtension) {
                    ((ExtendedExtension)installedExtension).onHandshakeResponse(extensionContext, responseExtension.getParameters());
                }
                extensions.add(installedExtension);
                this.debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, "Installed extension: ", installedExtension.getName());
            }
        }
        final Session sessionForRemoteEndpoint = this.endpointWrapper.createSessionForRemoteEndpoint(socket, upgradeResponse.getFirstHeaderValue("Sec-WebSocket-Protocol"), extensions, this.debugContext);
        ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getConfigurator().afterResponse(upgradeResponse);
        this.protocolHandler.setWriter(writer);
        this.protocolHandler.setWebSocket(socket);
        this.protocolHandler.setExtensions(extensions);
        this.protocolHandler.setExtensionContext(extensionContext);
        socket.onConnect(this.clientHandShake.getRequest(), null, null, null, this.debugContext);
        this.listener.onSessionCreated(sessionForRemoteEndpoint);
        Integer tyrusIncomingBufferSize = Utils.getProperty(this.properties, "org.glassfish.tyrus.incomingBufferSize", Integer.class);
        Integer wlsIncomingBufferSize = Utils.getProperty(this.endpointWrapper.getEndpointConfig().getUserProperties(), "weblogic.websocket.tyrus.incoming-buffer-size", Integer.class);
        final Integer incomingBufferSize = tyrusIncomingBufferSize == null && wlsIncomingBufferSize == null ? Integer.valueOf(0x40000B) : (wlsIncomingBufferSize != null ? wlsIncomingBufferSize : tyrusIncomingBufferSize);
        this.debugContext.appendLogMessage(LOGGER, Level.FINE, DebugContext.Type.OTHER, "Incoming buffer size: ", incomingBufferSize);
        return new ClientEngine.ClientUpgradeInfo(){

            @Override
            public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
                return ClientEngine.ClientUpgradeStatus.SUCCESS;
            }

            @Override
            public Connection createConnection() {
                return new Connection(){
                    private final ReadHandler readHandler;
                    {
                        this.readHandler = new TyrusReadHandler(TyrusClientEngine.this.protocolHandler, socket, incomingBufferSize, sessionForRemoteEndpoint.getNegotiatedExtensions(), extensionContext);
                    }

                    @Override
                    public ReadHandler getReadHandler() {
                        return this.readHandler;
                    }

                    @Override
                    public Writer getWriter() {
                        return writer;
                    }

                    @Override
                    public Connection.CloseListener getCloseListener() {
                        return closeListener;
                    }

                    @Override
                    public void close(CloseReason reason) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage(), e);
                        }
                        socket.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
                        for (Extension extension2 : sessionForRemoteEndpoint.getNegotiatedExtensions()) {
                            if (!(extension2 instanceof ExtendedExtension)) continue;
                            ((ExtendedExtension)extension2).destroy(extensionContext);
                        }
                    }
                };
            }
        };
    }

    public ClientEngine.TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    private static enum TyrusClientEngineState {
        INIT,
        REDIRECT_REQUIRED,
        AUTH_REQUIRED,
        AUTH_UPGRADE_REQUEST_CREATED,
        UPGRADE_REQUEST_CREATED,
        FAILED,
        SUCCESS;

        private volatile Authenticator authenticator;
        private volatile String wwwAuthenticateHeader;

        Authenticator getAuthenticator() {
            return this.authenticator;
        }

        void setAuthenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
        }

        String getWwwAuthenticateHeader() {
            return this.wwwAuthenticateHeader;
        }

        void setWwwAuthenticateHeader(String wwwAuthenticateHeader) {
            this.wwwAuthenticateHeader = wwwAuthenticateHeader;
        }
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final int incomingBufferSize;
        private final ProtocolHandler handler;
        private final TyrusWebSocket socket;
        private final List<Extension> negotiatedExtensions;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private ByteBuffer buffer = null;

        TyrusReadHandler(ProtocolHandler protocolHandler, TyrusWebSocket socket, int incomingBufferSize, List<Extension> negotiatedExtensions, ExtendedExtension.ExtensionContext extensionContext) {
            this.handler = protocolHandler;
            this.socket = socket;
            this.incomingBufferSize = incomingBufferSize;
            this.negotiatedExtensions = negotiatedExtensions;
            this.extensionContext = extensionContext;
            protocolHandler.setExtensionContext(extensionContext);
        }

        @Override
        public void handle(ByteBuffer data) {
            block11: {
                try {
                    if (data == null || !data.hasRemaining()) break block11;
                    if (this.buffer != null) {
                        data = Utils.appendBuffers(this.buffer, data, this.incomingBufferSize, 256);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException("Buffer overflow.");
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result2 = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result2.flip();
                        data = Utils.appendBuffers(result2, data, this.incomingBufferSize, 256);
                    }
                    while (true) {
                        Frame frame;
                        if ((frame = this.handler.unframe(data)) == null) {
                            this.buffer = data;
                            break;
                        }
                        for (Extension extension2 : this.negotiatedExtensions) {
                            if (!(extension2 instanceof ExtendedExtension)) continue;
                            try {
                                frame = ((ExtendedExtension)extension2).processIncoming(this.extensionContext, frame);
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.FINE, String.format("Extension '%s' threw an exception during processIncoming method invocation: \"%s\".", extension2.getName(), t.getMessage()), t);
                            }
                        }
                        this.handler.process(frame, this.socket);
                    }
                }
                catch (WebSocketException e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(e.getCloseReason()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage())));
                }
            }
        }
    }

    public static interface ClientHandshakeListener {
        public void onSessionCreated(Session var1);

        public void onError(Throwable var1);
    }
}

